<?php
require_once "conexion.php";

class ModeloConfiguracion{

    static public function mdlEditarConfiguracion($datos){

        if(empty($datos['logo'])){
            $stmt = Conexion::conectar()->prepare("UPDATE configuracion SET razon_social = :razon_social, email = :email, prefijo = :prefijo, celular = :celular, direccion = :direccion, cambio = :cambio WHERE id = :id");
        } else {
            $stmt = Conexion::conectar()->prepare("UPDATE configuracion SET razon_social = :razon_social, email = :email, prefijo = :prefijo, celular = :celular, direccion = :direccion, cambio = :cambio, logo = :logo WHERE id = :id");
        }

        
        $stmt->bindParam(":razon_social", $datos['razon_social'], PDO::PARAM_STR);
        $stmt->bindParam(":email", $datos['email'], PDO::PARAM_STR);
        $stmt->bindParam(":prefijo", $datos['prefijo'], PDO::PARAM_STR);
        $stmt->bindParam(":celular", $datos['celular'], PDO::PARAM_STR);
        $stmt->bindParam(":direccion", $datos['direccion'], PDO::PARAM_STR);
        $stmt->bindParam(":cambio", $datos['cambio'], PDO::PARAM_STR);
       

        if(!empty($datos['logo']))
            $stmt->bindParam(":logo", $datos['logo'], PDO::PARAM_STR);
        
        $stmt->bindParam(":id", $datos['id'], PDO::PARAM_INT);

        if($stmt->execute()){
            return "ok";
        } else {
            return "error";
        }
       
		$stmt = null;
    }

    static public function mdlMostrarConfiguracion($tabla){
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");
        $stmt->execute();
        $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return is_array($resultado) ? $resultado : array();
		$stmt = null;
    }

   
}